<?php
ini_set('display_errors', FALSE);
ini_set('display_startup_errors', FALSE);

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB()
{    
    $db = parse_ini_file("../../lib/datasource.ini");
    $conexion = mysqli_connect($db['ServidorBD'],$db['UsuarioBD'],$db['ClaveBD'],$db['NombreBD']);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECT
////////////////////////////////////////////////////////////////////////////////////////////////////
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    $retorno = "";
    if($row = mysqli_fetch_array($result))
    {
        $retorno = $row[0];
        $i++;
    }
    return $retorno; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
///////////////////////////////////////////////////////////////////////////////////////////////////
function EjecutarSQL($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
    if(strtoupper(substr($sql,0,6)) == "INSERT")
        $retorno = mysqli_insert_id($conexion);
    disconnectDB($conexion); //desconectamos la base de datos
    return($retorno);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
////  Muestro la DATA en Pantalla
//////////////////////////////////////////////////////////////////////////////////////////////////

try{

    $array = json_decode(file_get_contents('php://input'), true);

    $detalles = "";
    $code = 0;
    $message = "";
    $diaoperativo = ""; $codsucursal = "";
    $i=0;
    foreach($array as $registros)
    {
        
        $codsucursal   = $registros['codsucursal'];
        $nomsucursal   = $registros['nomsucursal'];
        $diaoperativo  = $registros['diaoperativo'];
        $dni           = $registros['dni'];
        $nombres       = $registros['nombres'];
        $apellidos     = $registros['apellidos'];
        $codproducto   = $registros['codproducto'];
        $nomproducto   = $registros['nomproducto'];
        $cantidad      = $registros['cantidad'];
        $valunitario   = $registros['valunitario'];
        $numfactura    = $registros['tipodoc'].$registros['prefijo'].$registros['numero'];
        $periodo       = $registros['periodo'];
        $observacion   = $registros['observacion'];
        $observacion2  = $registros['observacion2'];
        $token         = $registros['token'];
        $codvende      = $registros['codvende'];
    
        $vsql3 = "INSERT INTO consolida5(CODSUCURSAL,NOMSUCURSAL,DIAOPERATIVO,TOKEN,DNIPACIENTE,NOMPACIENTE,APEPACIENTE,NOMPRODUCTO,CODPRODUCTO,
                  NUMFACTURA,CANTIDAD,VALOR,PERIODO,CREADOR,MOMENTO,OBSERVACION1,OBSERVACION2,CODVENDE)
                  VALUES('".$codsucursal."','".$nomsucursal."','".$diaoperativo."','".$token."','".$dni."','".$nombres."','".$apellidos."','".$nomproducto."','".$codproducto."',
                  '".$numfactura."','".$cantidad."','".$valunitario."','".$periodo."','SYSTEM',CURRENT_TIMESTAMP,'".$observacion."','".$observacion2."','".$codvende."')";
        EjecutarSQL($vsql3);

        $i++;  
    }    

    /// Mensaje de Respuesta 
    $code = 200;
    $message = "Informacion recibida con Exito. ".$i." Registros Actualizados";    

    /// Retorno la respuesta correspondiente
    $response = array("code" => $code , "Mensaje" => $message );
    header('Content-type: application/json; charset=utf-8');
    echo json_encode($response);

} catch (Exception $e) {
    echo 'Excepción capturada: ',  $e->getMessage(), "\n";
}

?>